import pandas as pd
import numpy as np

def generatePMFforModel(level):
    video_name = 'VID_084027'

    models_first = ['m2', 'm2', 'm2', 'm2']
    models_second = ['y5m', 'y5l', 'y5l']
    models = models_first + models_second

    data_version = 'aeresults'
    energy_version = 'ene'

    excel_path = '/Users/Desktop/Python Projects/NeurIPS24/data/aeresults/VID_084027_ene.xlsx'
    df = pd.read_excel(excel_path)


    data = []
    for model in models:
        list2 = df[model].tolist()
        data.append(list2)

    min_val = 0 # np.min(data)
    max_val = np.max(data)
    print("normalization scalar is", max_val)
    diff = max_val - min_val


    data = [[element / diff for element in sublist] for sublist in data]

    model_sel = level
    model_data = data[model_sel]

    num_bins = 10

    min_val = 0
    max_val = 1

    bins = np.linspace(min_val, max_val, num_bins + 1)

    hist, bin_edges = np.histogram(model_data, bins=bins, density=True)

    cdf = np.cumsum(hist * np.diff(bin_edges))

    pmf = []    # every pmf
    for i in range(len(cdf)):
        if i == 0:
            pmf.append(cdf[i])
        else:
            pmf.append(cdf[i] - cdf[i-1])
    pmf = np.array(pmf)

    return pmf

